#include "Main.h"

// WARNING: It modifies the parameter.
char *stringToLower(char *str, int maxlen)
{
	char *start = str;
	assert(str != NULL);
	assert(maxlen > 0);
	while ((*str != '\0') && (maxlen > 0))
	{
		if (*str >= 'A' && *str <= 'Z') *str = *str + ('a'-'A');
		str++;
		maxlen--;
	}
	return start;
}

int parseNumber(char *str, int len, int *res)
{
	int numRead = 0;
	assert(str != NULL);
	assert(res != NULL);
	assert(len > 0);

	*res = 0;

	while (*str != '\0' && len > 0)
	{
		if (*str >= '0' && *str <= '9')
		{
			if (numRead > 0) *res = *res * 10;
			*res = (*res) + (*str - '0');
			numRead++;
		}
		str++;
		len--;
	}
	return numRead;
}

// prereq: cmd must be lowercased!
int parseGridSquare(char *cmd, int cmdlen, int *resx, int *resy)
{
	int state = 1, numState = 1;
	int lettersPresent = 0;
	assert(cmd != NULL);
	assert(resx != NULL);
	assert(resy != NULL);

	*resx = 0;
	*resy = 0;

	if (strlen(cmd) < 2) return 0;
	while ((*cmd != '\0') && (cmdlen > 0))
	{
		if (*cmd >= 'a' && *cmd <= 'z') 
		{
			if (state > 1)
			{
				*resx = (*resx+1) * 26;
			}
			*resx = *resx + (*cmd - 'a');
			state++;
			if (lettersPresent == 0) lettersPresent = 1;
		}
		else if (*cmd >= '0' && *cmd <= '9')
		{
			if (numState > 1) *resy = *resy * 10;
			*resy = *resy + (*cmd - '0');
			numState++;
			if (lettersPresent == 1) lettersPresent = 2;
		}
		cmd++;
		cmdlen--;
	}
	(*resy)--;
	if (lettersPresent != 2) return 0; // either the letter or the number were missing
	if (!XYVALID(*resx, *resy)) return 0;
	else return 1;
}

// Math.h lacks power function for integers
int pow (int x, int power) 
{
	int ret = x;
	assert (power > 0);
	for (; power>1; power--) ret = ret * x;
	return ret;
}

// Math.h lacks abs for integers
int abs (int val) { if (val < 0) return -val; return val; }