#include "Main.h"

// a helper function for AI shooting
int AI_Shoot(unsigned char* map, int x, int y, Game *g) 
{
	char buf[256];
	int ret;
	assert (map != NULL);
	assert (g != NULL);
	assert (XYVALID(x,y));

	MapCoordsToGrid(x,y, buf, sizeof(buf));
	printfCon (&(g->con),"AI Fires at %s... ", buf);
	ret = Shoot(map, x, y, &(g->con));

	assert (ret != -1);
	// if this is triggered, then the AI tried to hit the same spot twice.
	// While technically it's not an error, it may suggest problems with
	// the AI algorithm.

	if (ret == 2) testDefeatCondition(g);
	return ret;
}

int shootAtRandom(Game *g, int *x, int *y, int useGrid, int avoidNeighbouring)
{
	int ret,tx,ty,val;
	assert(g != NULL);
	assert (x != NULL);
	assert (y != NULL);
	while (1)
	{
		*x = rand() % gameWidth;
		*y = rand() % gameHeight;
		ret = mapGet(g->mapPlayer,*x,*y);
		if (!(ret & F_SHOT_FIRED))
		{
			if (!useGrid) break;
			if (!avoidNeighbouring) break;
			if (useGrid && !(ret & F_NEIGHBOR_SHOT)) break;
			if (avoidNeighbouring && (ret & F_NEIGHBOURING))
			{
				//ensure that the AI actually KNOWS that this is a neighbouring block
				ret = 0;
				for (ty = (*y)-1; ty <= (*y)+1; ty++)
				{
					for (tx = (*x)-1; tx <= (*x)+1; tx++)
					{
						if (!XYVALID(tx,ty)) continue;
						val = mapGet(g->mapPlayer, tx, ty);
						if (! (val & F_SHOT_FIRED)) continue;
						if (val & F_SHIP_PRESENT)
						{
							ret = 1;
							break; // inner for
						}
					}
					if (ret == 1) break; // outer for
				}
				if (ret == 0) break; // if the AI doesn't know it's a neighbouring block
				// then proceed and fire at it, as the avoidNeighbouring setting
				// has no effect here.
			}
		}
	}
	
	ret = AI_Shoot(g->mapPlayer, *x, *y, g);
	if (ret == 2) testDefeatCondition(g);
	return ret;
}

// The stupid AI shoots completely at random
// It doesn't even care if it hits anything
void stupidAITurn(Game *g)
{
	int x,y,shotsLeft;
	assert(g != NULL);
	shotsLeft = shotsPerTurn;
	while (shotsLeft > 0)
	{
		// shoot completely at random without thinking :D
		// only care about not shooting the same grid twice
		shootAtRandom(g, &x, &y, 0, 0);
		if (g->opponentWon) break;
		shotsLeft--;
	}
}



// The Adept AI shoots at random just like the stupid AI,
// but it can track its target once it hits someting
void adeptAITurn(Game *g)
{
	TrackingAIBase(g, 0, 0);
}

// the Expert AI uses the grid method
// to locate your ships faster
void ExpertAITurn(Game *g)
{
	TrackingAIBase(g, 1, 0);
}

// The most challenging AI will use
// the grid strategy, as well as a limited possibility
// of looking up your ships. It can be adjusted
// by cheating aggressiveness factor (the higher it is
// the more often the AI cheats.)
// cheating is decided on per-shot basis. Whenever a
// cheating shot occurs, the game comments on 
// how 'lucky' the shot was.
void CheatingAITurn(Game *g)
{
	// <0,1000>: 0=no cheating, 1000=always cheating
	const int cheating_aggresiveness = 147;

	int x,y, val;
	int shotsLeft = shotsPerTurn;
	assert (g != NULL);

	while (shotsLeft > 0)
	{
		if ((g->aiLuckyShots > 0) && ((rand()%1000) < cheating_aggresiveness))
		{
			// do the cheating
			g->aiLuckyShots--;
			if (TrackingAILoop(g, 1, 1) == 0) break;
		}
		else
		{
			// if no cheating use the standard tracking AI
			if (TrackingAILoop(g, 1, 0) == 0) break;
		}
		shotsLeft--;
	}
}

void (*doOpponentsTurn)(Game*) = CheatingAITurn;
